/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cordova;

import java.security.SecureRandom;
import org.apache.cordova.CordovaResourceApi;
import org.apache.cordova.LOG;
import org.apache.cordova.NativeToJsMessageQueue;
import org.apache.cordova.PluginManager;
import org.json.JSONArray;
import org.json.JSONException;

public class CordovaBridge {
    private static final String LOG_TAG = "CordovaBridge";
    private PluginManager pluginManager;
    private NativeToJsMessageQueue jsMessageQueue;
    private volatile int expectedBridgeSecret = -1;

    public CordovaBridge(PluginManager pluginManager, NativeToJsMessageQueue jsMessageQueue) {
        this.pluginManager = pluginManager;
        this.jsMessageQueue = jsMessageQueue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String jsExec(int bridgeSecret, String service, String action, String callbackId, String arguments) throws JSONException, IllegalAccessException {
        if (!this.verifySecret("exec()", bridgeSecret)) {
            return null;
        }
        if (arguments == null) {
            return "@Null arguments.";
        }
        this.jsMessageQueue.setPaused(true);
        try {
            CordovaResourceApi.jsThread = Thread.currentThread();
            this.pluginManager.exec(service, action, callbackId, arguments);
            String ret = null;
            String string = ret = this.jsMessageQueue.popAndEncode(false);
            return string;
        }
        catch (Throwable e) {
            e.printStackTrace();
            String string = "";
            return string;
        }
        finally {
            this.jsMessageQueue.setPaused(false);
        }
    }

    public void jsSetNativeToJsBridgeMode(int bridgeSecret, int value) throws IllegalAccessException {
        if (!this.verifySecret("setNativeToJsBridgeMode()", bridgeSecret)) {
            return;
        }
        this.jsMessageQueue.setBridgeMode(value);
    }

    public String jsRetrieveJsMessages(int bridgeSecret, boolean fromOnlineEvent) throws IllegalAccessException {
        if (!this.verifySecret("retrieveJsMessages()", bridgeSecret)) {
            return null;
        }
        return this.jsMessageQueue.popAndEncode(fromOnlineEvent);
    }

    private boolean verifySecret(String action, int bridgeSecret) throws IllegalAccessException {
        if (!this.jsMessageQueue.isBridgeEnabled()) {
            if (bridgeSecret == -1) {
                LOG.d(LOG_TAG, action + " call made before bridge was enabled.");
            } else {
                LOG.d(LOG_TAG, "Ignoring " + action + " from previous page load.");
            }
            return false;
        }
        if (this.expectedBridgeSecret < 0 || bridgeSecret != this.expectedBridgeSecret) {
            LOG.e(LOG_TAG, "Bridge access attempt with wrong secret token, possibly from malicious code. Disabling exec() bridge!");
            this.clearBridgeSecret();
            throw new IllegalAccessException();
        }
        return true;
    }

    void clearBridgeSecret() {
        this.expectedBridgeSecret = -1;
    }

    public boolean isSecretEstablished() {
        return this.expectedBridgeSecret != -1;
    }

    int generateBridgeSecret() {
        SecureRandom randGen = new SecureRandom();
        this.expectedBridgeSecret = randGen.nextInt(Integer.MAX_VALUE);
        return this.expectedBridgeSecret;
    }

    public void reset() {
        this.jsMessageQueue.reset();
        this.clearBridgeSecret();
    }

    public String promptOnJsPrompt(String origin, String message, String defaultValue) {
        if (defaultValue != null && defaultValue.length() > 3 && defaultValue.startsWith("gap:")) {
            try {
                JSONArray array = new JSONArray(defaultValue.substring(4));
                int bridgeSecret = array.getInt(0);
                String service = array.getString(1);
                String action = array.getString(2);
                String callbackId = array.getString(3);
                String r = this.jsExec(bridgeSecret, service, action, callbackId, message);
                return r == null ? "" : r;
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            return "";
        }
        if (defaultValue != null && defaultValue.startsWith("gap_bridge_mode:")) {
            try {
                int bridgeSecret = Integer.parseInt(defaultValue.substring(16));
                this.jsSetNativeToJsBridgeMode(bridgeSecret, Integer.parseInt(message));
            }
            catch (NumberFormatException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            return "";
        }
        if (defaultValue != null && defaultValue.startsWith("gap_poll:")) {
            int bridgeSecret = Integer.parseInt(defaultValue.substring(9));
            try {
                String r = this.jsRetrieveJsMessages(bridgeSecret, "1".equals(message));
                return r == null ? "" : r;
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
                return "";
            }
        }
        if (defaultValue != null && defaultValue.startsWith("gap_init:")) {
            if (this.pluginManager.shouldAllowBridgeAccess(origin)) {
                int bridgeMode = Integer.parseInt(defaultValue.substring(9));
                this.jsMessageQueue.setBridgeMode(bridgeMode);
                int secret = this.generateBridgeSecret();
                return "" + secret;
            }
            LOG.e(LOG_TAG, "gap_init called from restricted origin: " + origin);
            return "";
        }
        return null;
    }
}

